/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.vw.api.VWException;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.IVWDesignerCanvasPanel;
import filenet.vw.toolkit.design.canvas.VWWindowMenuItem;
import filenet.vw.toolkit.design.canvas.config.VWConfigCanvasPanel;
import filenet.vw.toolkit.design.canvas.images.VWImageLoader;
import filenet.vw.toolkit.design.canvas.inbaskets.VWInbasketCanvasPanel;
import filenet.vw.toolkit.design.canvas.process.IVWProcessCanvasPanel;
import filenet.vw.toolkit.design.canvas.process.VWProcessCanvasPanel;
import filenet.vw.toolkit.design.canvas.process.diagram.VWDiagramCanvasPanel;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.canvas.roles.VWRoleCanvasPanel;
import filenet.vw.toolkit.design.canvas.simulation.VWScenarioCanvasPanel;
import filenet.vw.toolkit.design.mapui.VWDesignerWorkflowPane;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.utils.VWPrinter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.IVWTabClosedListener;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.VWCloseableTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWDesignerTabbedCanvasPanel
extends JPanel
implements ActionListener,
IVWCoordinationEventListener,
IVWTabClosedListener,
ChangeListener,
IVWMapChangedListener {
    private VWDesignerCoreData m_designerCoreData = null;
    private Vector<IVWProcessCanvasPanel> m_workflowPanelList = null;
    private Vector<VWScenarioCanvasPanel> m_scenarioPanelList = null;
    private VWConfigCanvasPanel m_configCanvasPanel = null;
    private VWRoleCanvasPanel m_roleCanvasPanel = null;
    private VWInbasketCanvasPanel m_inbasketCanvasPanel = null;
    private VWCloseableTabbedPane m_closeableTabbedPane = null;
    private VWPrinter m_vwPrinter = null;

    public void init(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
        this.m_workflowPanelList = new Vector();
        this.m_scenarioPanelList = new Vector();
        this.createControls();
        try {
            if (this.m_designerCoreData.getSessionInfo().getDisplayConfigurationFunctionality()) {
                this.m_configCanvasPanel = new VWConfigCanvasPanel(this.m_designerCoreData);
                this.updatePanelsComponentOrientation(this.m_configCanvasPanel);
            }
        }
        catch (VWException vWException) {
            // empty catch block
        }
        this.m_designerCoreData.getCoordinationEventNotifier().addCoordinationEventListener(this);
    }

    public VWPrinter getVWPrinter(String processName) {
        try {
            if (this.m_vwPrinter == null) {
                this.m_vwPrinter = new VWPrinter(this.m_designerCoreData.getSessionInfo().getParentFrame(), this.m_designerCoreData.getSessionInfo());
            }
            if (processName == null) {
                Component selectedComponent = this.m_closeableTabbedPane.getSelectedComponent();
                if (selectedComponent != null && selectedComponent instanceof IVWProcessCanvasPanel) {
                    this.m_vwPrinter.setupPrintable(((IVWProcessCanvasPanel)((Object)selectedComponent)).getWorkflowPane());
                    return this.m_vwPrinter;
                }
            } else {
                IVWProcessCanvasPanel canvasPanel = this.findProcessPanel(processName);
                if (canvasPanel != null) {
                    this.m_vwPrinter.setupPrintable(canvasPanel.getWorkflowPane());
                    return this.m_vwPrinter;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public void performPrintSetup() {
        try {
            VWPrinter vwPrinter = this.getVWPrinter(null);
            if (vwPrinter != null) {
                vwPrinter.printSetup();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void performPrintPreview() {
        try {
            VWPrinter vwPrinter = this.getVWPrinter(null);
            if (vwPrinter != null) {
                vwPrinter.printPreview();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void stopEditing() {
        for (int nIndex = 0; nIndex < this.m_workflowPanelList.size(); ++nIndex) {
            IVWProcessCanvasPanel canvasPanel = this.m_workflowPanelList.elementAt(nIndex);
            if (canvasPanel == null) continue;
            canvasPanel.stopEditing();
        }
    }

    public void showInheritedWorkflowInformation(boolean bNewDisplayInheritedItemsValue) {
        for (int nIndex = 0; nIndex < this.m_workflowPanelList.size(); ++nIndex) {
            IVWProcessCanvasPanel canvasPanel = this.m_workflowPanelList.elementAt(nIndex);
            if (canvasPanel == null) continue;
            canvasPanel.showInheritedWorkflowInformation(bNewDisplayInheritedItemsValue);
        }
    }

    public boolean isOkayToExit() {
        if (!this.saveConfigurationChanges(true)) {
            return false;
        }
        return this.resetAll();
    }

    public boolean saveConfigurationChanges(boolean bCommitConfiguration) {
        if (this.m_roleCanvasPanel != null) {
            this.m_roleCanvasPanel.notifyListeners();
        }
        if (this.m_inbasketCanvasPanel != null) {
            this.m_inbasketCanvasPanel.notifyListeners();
        }
        if (bCommitConfiguration && this.m_configCanvasPanel != null) {
            return this.m_configCanvasPanel.isOkayToExit();
        }
        return true;
    }

    public void releaseReferences() {
        if (this.m_workflowPanelList != null) {
            this.m_workflowPanelList.removeAllElements();
            this.m_workflowPanelList = null;
        }
        if (this.m_scenarioPanelList != null) {
            this.m_scenarioPanelList.removeAllElements();
            this.m_scenarioPanelList = null;
        }
        if (this.m_configCanvasPanel != null) {
            this.m_configCanvasPanel.releaseReferences();
            this.m_configCanvasPanel = null;
        }
        if (this.m_roleCanvasPanel != null) {
            this.m_roleCanvasPanel.releaseReferences();
            this.m_roleCanvasPanel = null;
        }
        if (this.m_inbasketCanvasPanel != null) {
            this.m_inbasketCanvasPanel.releaseReferences();
            this.m_inbasketCanvasPanel = null;
        }
        if (this.m_closeableTabbedPane != null) {
            this.m_closeableTabbedPane.removeAll();
            this.m_closeableTabbedPane = null;
        }
        this.m_designerCoreData = null;
        this.m_vwPrinter = null;
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object instanceof VWWindowMenuItem) {
            VWWindowMenuItem menuItem = (VWWindowMenuItem)object;
            this.m_closeableTabbedPane.setSelectedComponent((Component)((Object)menuItem.getCanvasPanel()));
        }
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        if (event.getSource() == this) {
            return;
        }
        try {
            block1 : switch (event.getID()) {
                case 700: 
                case 755: {
                    this.resetAll();
                    break;
                }
                case 715: {
                    this.addProcessPanel((VWAuthPropertyData)event.getEventParam());
                    break;
                }
                case 707: {
                    VWWorkflowDefinition wflDef = (VWWorkflowDefinition)event.getEventParam();
                    if (wflDef == null) break;
                    IVWProcessCanvasPanel canvasPanel = this.findProcessPanel(wflDef.getName());
                    if (canvasPanel != null) {
                        this.removeComponent((JPanel)((Object)canvasPanel));
                    }
                    break;
                }
                case 709: {
                    this.handleNewMainProcessEvent();
                    break;
                }
                case 717: {
                    VWAuthPropertyData authPropertyData = (VWAuthPropertyData)event.getEventParam();
                    IVWProcessCanvasPanel canvasPanel = this.findProcessPanel(authPropertyData.getWorkflowDefinition().getName());
                    if (canvasPanel == null) {
                        canvasPanel = this.addProcessPanel((VWAuthPropertyData)event.getEventParam());
                    }
                    canvasPanel.displayWorkflowProperties();
                    break;
                }
                case 718: {
                    Component selectedComponent = this.m_closeableTabbedPane.getSelectedComponent();
                    if (selectedComponent == null || !(selectedComponent instanceof VWProcessCanvasPanel)) break;
                    VWProcessCanvasPanel canvasPanel = (VWProcessCanvasPanel)selectedComponent;
                    canvasPanel.selectItemInProcess((Object[])event.getEventParam());
                    break;
                }
                case 741: {
                    for (int nIndex = 0; nIndex < this.m_workflowPanelList.size(); ++nIndex) {
                        IVWProcessCanvasPanel canvasPanel = this.m_workflowPanelList.elementAt(nIndex);
                        if (canvasPanel == null) continue;
                        VWDesignerWorkflowPane mapPane = canvasPanel.getWorkflowPane();
                        mapPane.updateUI();
                    }
                    break;
                }
                case 742: {
                    for (int nIndex = 0; nIndex < this.m_workflowPanelList.size(); ++nIndex) {
                        IVWProcessCanvasPanel canvasPanel = this.m_workflowPanelList.elementAt(nIndex);
                        if (canvasPanel == null) continue;
                        VWDesignerWorkflowPane mapPane = canvasPanel.getWorkflowPane();
                        mapPane.updateStepUI();
                    }
                    break;
                }
                case 743: {
                    for (int nIndex = 0; nIndex < this.m_workflowPanelList.size(); ++nIndex) {
                        IVWProcessCanvasPanel canvasPanel = this.m_workflowPanelList.elementAt(nIndex);
                        if (canvasPanel == null) continue;
                        VWDesignerWorkflowPane mapPane = canvasPanel.getWorkflowPane();
                        mapPane.updateRouteUI();
                    }
                    break;
                }
                case 744: {
                    for (int nIndex = 0; nIndex < this.m_workflowPanelList.size(); ++nIndex) {
                        IVWProcessCanvasPanel canvasPanel = this.m_workflowPanelList.elementAt(nIndex);
                        if (canvasPanel == null) continue;
                        VWDesignerWorkflowPane mapPane = canvasPanel.getWorkflowPane();
                        mapPane.updateTextAnnotationUI();
                    }
                    break;
                }
                case 730: {
                    this.addScenarioPanel((VWSIMPropertyData)event.getEventParam());
                    break;
                }
                case 727: {
                    VWScenarioDefinition scenarioDef = (VWScenarioDefinition)event.getEventParam();
                    if (scenarioDef == null) break;
                    VWScenarioCanvasPanel canvasPanel = this.findScenarioPanel(scenarioDef.getName());
                    if (canvasPanel != null) {
                        this.removeComponent(canvasPanel);
                    }
                    break;
                }
                case 726: {
                    VWScenarioDefinition scenarioDef = (VWScenarioDefinition)event.getEventParam();
                    if (scenarioDef == null) break;
                    VWScenarioCanvasPanel canvasPanel = this.findScenarioPanel(scenarioDef.getName());
                    if (canvasPanel != null) {
                        for (int nIndex = 0; nIndex < this.m_closeableTabbedPane.getTabCount(); ++nIndex) {
                            Component component = this.m_closeableTabbedPane.getComponentAt(nIndex);
                            if (!component.equals(canvasPanel)) continue;
                            this.m_closeableTabbedPane.setTitleAt(nIndex, scenarioDef.getName());
                            break block1;
                        }
                    }
                    break;
                }
                case 735: {
                    this.addConfigurationPanel();
                    break;
                }
                case 736: {
                    this.addRolePanel();
                    break;
                }
                case 737: {
                    this.addInbasketPanel();
                    break;
                }
                case 756: {
                    if (this.m_configCanvasPanel == null) break;
                    boolean bUseCurrentConfig = true;
                    if (event.getEventParam() != null && event.getEventParam() instanceof Boolean) {
                        bUseCurrentConfig = (Boolean)event.getEventParam();
                    }
                    this.m_configCanvasPanel.fireRefreshRegionConfigEvent(bUseCurrentConfig);
                    break;
                }
                case 758: {
                    if (this.m_configCanvasPanel == null) break;
                    this.m_configCanvasPanel.handleDiscardChangesEvent();
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public void closeOperation(int nTabIndex) {
        Component component = this.m_closeableTabbedPane.getComponentAt(nTabIndex);
        if (component != null) {
            this.removeComponent(component);
        }
    }

    public void stateChanged(ChangeEvent event) {
        Component component = this.m_closeableTabbedPane.getSelectedComponent();
        if (component != null) {
            IVWDesignerCanvasPanel canvasPanel = null;
            if (component instanceof IVWProcessCanvasPanel) {
                canvasPanel = (IVWDesignerCanvasPanel)((Object)component);
                ((IVWProcessCanvasPanel)canvasPanel).setSelected();
            } else if (component instanceof VWScenarioCanvasPanel) {
                canvasPanel = (IVWDesignerCanvasPanel)((Object)component);
            } else if (component instanceof VWConfigCanvasPanel) {
                canvasPanel = (IVWDesignerCanvasPanel)((Object)component);
            } else if (component instanceof VWRoleCanvasPanel) {
                canvasPanel = (IVWDesignerCanvasPanel)((Object)component);
            } else if (component instanceof VWInbasketCanvasPanel) {
                canvasPanel = (IVWDesignerCanvasPanel)((Object)component);
            }
            if (this.m_roleCanvasPanel != null) {
                this.m_roleCanvasPanel.notifyListeners();
            }
            if (this.m_inbasketCanvasPanel != null) {
                this.m_inbasketCanvasPanel.notifyListeners();
            }
            if (canvasPanel != null) {
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 720, canvasPanel);
            }
        }
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 555: {
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 706, event.paramString());
                for (int nIndex = 0; nIndex < this.m_closeableTabbedPane.getTabCount(); ++nIndex) {
                    Component component = this.m_closeableTabbedPane.getComponentAt(nIndex);
                    if (!(component instanceof IVWProcessCanvasPanel)) continue;
                    IVWProcessCanvasPanel processPanel = (IVWProcessCanvasPanel)((Object)component);
                    String processName = processPanel.getAuthPropertyData().getWorkflowDefinition().getName();
                    this.m_closeableTabbedPane.setTitleAt(nIndex, processName);
                }
                break;
            }
        }
    }

    private void createControls() {
        this.setLayout(new BorderLayout());
        this.m_closeableTabbedPane = new VWCloseableTabbedPane();
        this.m_closeableTabbedPane.addTabClosedListener(this);
        this.m_closeableTabbedPane.addChangeListener(this);
        this.add((Component)this.m_closeableTabbedPane, "Center");
    }

    private IVWProcessCanvasPanel findProcessPanel(String processName) {
        for (int nIndex = 0; nIndex < this.m_workflowPanelList.size(); ++nIndex) {
            String tempWflName;
            IVWProcessCanvasPanel canvasPanel = this.m_workflowPanelList.elementAt(nIndex);
            if (canvasPanel == null || VWStringUtils.compare(processName, tempWflName = canvasPanel.getAuthPropertyData().getWorkflowDefinition().getName()) != 0) continue;
            return canvasPanel;
        }
        return null;
    }

    private void handleNewMainProcessEvent() {
        VWWorkflowDefinition mainWflDef = this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition().getMainWorkflow();
        if (mainWflDef == null) {
            return;
        }
        for (int nIndex = 0; nIndex < this.m_closeableTabbedPane.getTabCount(); ++nIndex) {
            IVWProcessCanvasPanel canvasPanel;
            Component component = this.m_closeableTabbedPane.getComponentAt(nIndex);
            if (!(component instanceof IVWProcessCanvasPanel) || (canvasPanel = (IVWProcessCanvasPanel)((Object)component)) == null) continue;
            String tempWflName = canvasPanel.getAuthPropertyData().getWorkflowDefinition().getName();
            ImageIcon tabIcon = null;
            tabIcon = VWStringUtils.compare(tempWflName, mainWflDef.getName()) == 0 ? VWImageLoader.createImageIcon("mainWorkflow16.gif") : VWImageLoader.createImageIcon("workflow16.gif");
            this.m_closeableTabbedPane.setIconAt(nIndex, tabIcon);
        }
    }

    private IVWProcessCanvasPanel addProcessPanel(VWAuthPropertyData authPropertyData) {
        String wflName = authPropertyData.getWorkflowDefinition().getName();
        IVWProcessCanvasPanel canvasPanel = this.findProcessPanel(wflName);
        if (canvasPanel == null) {
            ImageIcon tabIcon = null;
            VWWorkflowDefinition mainWflDef = authPropertyData.getWorkflowCollectionDefinition().getMainWorkflow();
            tabIcon = mainWflDef != null && VWStringUtils.compare(wflName, mainWflDef.getName()) == 0 ? VWImageLoader.createImageIcon("mainWorkflow16.gif") : VWImageLoader.createImageIcon("workflow16.gif");
            canvasPanel = this.m_designerCoreData.getApplicationMode() == 0 ? new VWDiagramCanvasPanel(this, authPropertyData) : new VWProcessCanvasPanel(this, authPropertyData);
            this.m_closeableTabbedPane.removeChangeListener(this);
            this.m_closeableTabbedPane.addTab(authPropertyData.getWorkflowDefinition().getName(), tabIcon, (JPanel)((Object)canvasPanel));
            this.m_closeableTabbedPane.addChangeListener(this);
            this.updatePanelsComponentOrientation((JPanel)((Object)canvasPanel));
            this.m_workflowPanelList.add(canvasPanel);
            this.displayWidWorkflowWarning(authPropertyData.getWorkflowDefinition());
            authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
        }
        this.m_closeableTabbedPane.setSelectedIndex(-1);
        this.m_closeableTabbedPane.setSelectedComponent((JPanel)((Object)canvasPanel));
        return canvasPanel;
    }

    private VWScenarioCanvasPanel findScenarioPanel(String scenarioName) {
        for (int nIndex = 0; nIndex < this.m_scenarioPanelList.size(); ++nIndex) {
            String tempName;
            VWScenarioCanvasPanel canvasPanel = this.m_scenarioPanelList.elementAt(nIndex);
            if (canvasPanel == null || VWStringUtils.compare(scenarioName, tempName = canvasPanel.getPropertyData().getScenarioDefinition().getName()) != 0) continue;
            return canvasPanel;
        }
        return null;
    }

    private VWScenarioCanvasPanel addScenarioPanel(VWSIMPropertyData simPropertyData) {
        String scenarioName = simPropertyData.getScenarioDefinition().getName();
        VWScenarioCanvasPanel canvasPanel = this.findScenarioPanel(scenarioName);
        if (canvasPanel == null) {
            canvasPanel = new VWScenarioCanvasPanel(simPropertyData, this.m_designerCoreData);
            this.m_closeableTabbedPane.removeChangeListener(this);
            this.m_closeableTabbedPane.addTab(scenarioName, VWImageLoader.createImageIcon("scenario16.gif"), canvasPanel);
            this.m_closeableTabbedPane.addChangeListener(this);
            this.updatePanelsComponentOrientation(canvasPanel);
            this.m_scenarioPanelList.add(canvasPanel);
        }
        this.m_closeableTabbedPane.setSelectedIndex(-1);
        this.m_closeableTabbedPane.setSelectedComponent(canvasPanel);
        return canvasPanel;
    }

    private void addConfigurationPanel() throws VWException {
        if (!this.m_designerCoreData.getSessionInfo().getDisplayConfigurationFunctionality()) {
            return;
        }
        if (this.m_closeableTabbedPane.indexOfComponent(this.m_configCanvasPanel) == -1) {
            this.m_closeableTabbedPane.removeChangeListener(this);
            this.m_closeableTabbedPane.addTab(VWResource.s_configuration, VWImageLoader.createImageIcon("iso_logon_16.gif"), this.m_configCanvasPanel);
            this.m_closeableTabbedPane.addChangeListener(this);
        }
        this.m_closeableTabbedPane.setSelectedIndex(-1);
        this.m_closeableTabbedPane.setSelectedComponent(this.m_configCanvasPanel);
    }

    private void addRolePanel() throws VWException {
        if (!this.m_designerCoreData.getSessionInfo().getDisplayConfigurationFunctionality()) {
            return;
        }
        if (this.m_roleCanvasPanel == null) {
            this.m_roleCanvasPanel = new VWRoleCanvasPanel(this.m_designerCoreData);
            this.m_closeableTabbedPane.removeChangeListener(this);
            this.m_closeableTabbedPane.addTab(VWResource.s_roles, VWImageLoader.createImageIcon("roles16.gif"), this.m_roleCanvasPanel);
            this.m_closeableTabbedPane.addChangeListener(this);
            this.updatePanelsComponentOrientation(this.m_roleCanvasPanel);
        }
        this.m_closeableTabbedPane.setSelectedIndex(-1);
        this.m_closeableTabbedPane.setSelectedComponent(this.m_roleCanvasPanel);
    }

    private void addInbasketPanel() throws VWException {
        if (!this.m_designerCoreData.getSessionInfo().getDisplayConfigurationFunctionality()) {
            return;
        }
        if (this.m_inbasketCanvasPanel == null) {
            this.m_inbasketCanvasPanel = new VWInbasketCanvasPanel(this.m_designerCoreData);
            this.m_closeableTabbedPane.removeChangeListener(this);
            this.m_closeableTabbedPane.addTab(VWResource.s_inbaskets, VWImageLoader.createImageIcon("in-basket16.gif"), this.m_inbasketCanvasPanel);
            this.m_closeableTabbedPane.addChangeListener(this);
            this.updatePanelsComponentOrientation(this.m_inbasketCanvasPanel);
        }
        this.m_closeableTabbedPane.setSelectedIndex(-1);
        this.m_closeableTabbedPane.setSelectedComponent(this.m_inbasketCanvasPanel);
    }

    private boolean resetAll() {
        for (int nTabIndex = 0; nTabIndex < this.m_closeableTabbedPane.getTabCount(); ++nTabIndex) {
            Component component = this.m_closeableTabbedPane.getComponentAt(nTabIndex);
            if (component == null || this.removeComponent(component)) continue;
            return false;
        }
        this.m_closeableTabbedPane.removeAll();
        this.m_workflowPanelList = new Vector();
        this.m_scenarioPanelList = new Vector();
        this.m_roleCanvasPanel = null;
        this.m_inbasketCanvasPanel = null;
        return true;
    }

    private boolean removeComponent(Component component) {
        if (component != null) {
            if (component instanceof IVWProcessCanvasPanel) {
                IVWProcessCanvasPanel processCanvasPanel = (IVWProcessCanvasPanel)((Object)component);
                if (processCanvasPanel.getWorkflowPane().getIsDirty()) {
                    this.m_designerCoreData.getProcessMenuHelper().setCollectionDirty();
                }
                if (component instanceof VWProcessCanvasPanel && this.m_workflowPanelList.size() == 1 && !this.m_designerCoreData.getStepPaletteDocumentHelper().saveChanges()) {
                    return false;
                }
                this.m_closeableTabbedPane.removeChangeListener(this);
                this.m_closeableTabbedPane.remove(component);
                this.m_closeableTabbedPane.addChangeListener(this);
                this.m_workflowPanelList.remove(component);
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 721, processCanvasPanel);
                processCanvasPanel.getAuthPropertyData().removeListeners();
                processCanvasPanel.releaseReferences();
            } else if (component instanceof VWScenarioCanvasPanel) {
                VWScenarioCanvasPanel scenarioPanel = (VWScenarioCanvasPanel)component;
                this.m_closeableTabbedPane.removeChangeListener(this);
                this.m_closeableTabbedPane.remove(component);
                this.m_closeableTabbedPane.addChangeListener(this);
                this.m_scenarioPanelList.remove(component);
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 721, scenarioPanel);
            } else if (component instanceof VWConfigCanvasPanel) {
                VWConfigCanvasPanel configCanvasPanel = (VWConfigCanvasPanel)component;
                this.m_closeableTabbedPane.removeChangeListener(this);
                this.m_closeableTabbedPane.remove(component);
                this.m_closeableTabbedPane.addChangeListener(this);
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 721, configCanvasPanel);
            } else if (component instanceof VWRoleCanvasPanel) {
                this.m_closeableTabbedPane.removeChangeListener(this);
                this.m_closeableTabbedPane.remove(component);
                this.m_closeableTabbedPane.addChangeListener(this);
                this.m_roleCanvasPanel.notifyListeners();
                this.m_roleCanvasPanel = null;
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 721, (VWRoleCanvasPanel)component);
            } else if (component instanceof VWInbasketCanvasPanel) {
                this.m_closeableTabbedPane.removeChangeListener(this);
                this.m_closeableTabbedPane.remove(component);
                this.m_closeableTabbedPane.addChangeListener(this);
                this.m_inbasketCanvasPanel.notifyListeners();
                this.m_inbasketCanvasPanel = null;
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 721, (VWInbasketCanvasPanel)component);
            }
            Component selectedComponent = this.m_closeableTabbedPane.getSelectedComponent();
            if (selectedComponent != null) {
                if (selectedComponent instanceof IVWProcessCanvasPanel) {
                    ((IVWProcessCanvasPanel)((Object)selectedComponent)).setSelected();
                }
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 720, (IVWDesignerCanvasPanel)((Object)selectedComponent));
            }
        }
        return true;
    }

    private void updatePanelsComponentOrientation(JPanel canvasPanel) {
        try {
            if (canvasPanel != null) {
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                canvasPanel.applyComponentOrientation(compOrientation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void displayWidWorkflowWarning(VWWorkflowDefinition wflDef) {
        if (wflDef == null) {
            return;
        }
        try {
            VWMapDefinition[] maps = wflDef.getMaps();
            if (maps != null) {
                for (int i = 0; i < maps.length; ++i) {
                    VWMapNode[] steps = maps[i].getSteps();
                    if (steps == null) continue;
                    for (int j = 0; j < steps.length; ++j) {
                        String authorTool = steps[j].getAuthorTool();
                        if (authorTool == null) continue;
                        if (authorTool.contentEquals("WID")) {
                            // empty if block
                        }
                        VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_workflowEditedByWID, 3);
                        return;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

